<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class SendNewPasswordNotification extends Notification
{
    use Queueable;

    protected $password;

    /**
     * Create a new notification instance.
     *
     * @param string $password
     */
    public function __construct($password)
    {
        $this->password = $password;
    }

    /**
     * Get the notification's delivery channels.
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject('Your New Password')
                    ->greeting('Hello ' . $notifiable->name . ',')
                    ->line('Your password has been reset.')
                    ->line('Here is your new password:')
                    ->line("**{$this->password}**")
                    ->line('Please log in and change your password as soon as possible for security.')
                    ->action('Login', url('/login'))
                    ->line('If you did not request this, please contact support immediately.');
    }
}
