<?php
namespace App\Services;

use App\Models\User;
use App\Models\SafeHavenTransferToken;
use Illuminate\Support\Facades\Http;

class SafeHavenService
{
    public static function cronToken() {
        $data = [
            "grant_type" => "refresh_token",
            "client_assertion_type" => "urn:ietf:params:oauth:client-assertion-type:jwt-bearer",
            "client_assertion" => config('savehaven.safe_haven_client_assertion'),
            "client_id" => config('savehaven.safe_haven_client_id'),
            'refresh_token' => config('savehaven.safe_haven_access_token'),
        ];

        logs()->info(config('savehaven.safe_haven_base_url').'oauth2/token');
        logs()->info(json_encode($data));
        $response = $response = Http::withHeaders([
            'accept' => "application/json",
            'content-type' => "application/json",
        ])->post(config('savehaven.safe_haven_base_url').'oauth2/token', $data);
        logs()->info( $response->json());
        return  $response->json();
    }
    public static function getToken() {

        $token = SafeHavenTransferToken::latest()->first();
        if($token == null) {
            self::cronToken();
        }

        return  json_decode($token["data_response"], true);
    }


    public static function makeTransfers(
        $nameEnquiryReference,
        $debitAccountNumber,
        $beneficiaryBankCode,
        $beneficiaryAccountNumber,
        $amount,
        $saveBeneficiary = true,
        $paymentReference
        ) {
        $data = [
            "nameEnquiryReference" => $nameEnquiryReference,
            "debitAccountNumber" => $debitAccountNumber,
            "beneficiaryBankCode" => $beneficiaryBankCode,
            "beneficiaryAccountNumber" => $beneficiaryAccountNumber,
            "amount" => $amount,
            "saveBeneficiary" => $saveBeneficiary,
            "paymentReference" =>  $paymentReference
        ];
        $tokenObj = self::getToken();
        logs()->info($tokenObj);
        logs()->info(config('savehaven.safe_haven_base_url').'transfers');
        logs()->info(json_encode($data));
        $response = $response = Http::withHeaders([
            'accept' => "application/json",
            'content-type' => "application/json",
            "ClientID" => $tokenObj["ibs_client_id"]
        ])->withToken($tokenObj["access_token"])->post(config('savehaven.safe_haven_base_url').'transfers', $data);
        return  $response->json();
    }



    public static function createVirtualAccounts(
        $validFor= 900,
        $callbackUrl,
        $settlementAccount,
        $amount,
        $externalReference,
        ) {
        $data = [
            "validFor" => $validFor,
            "callbackUrl" => $callbackUrl,
            "settlementAccount" => [
                "bankCode" => "999240",
                "accountNumber" => $settlementAccount
            ],
            "amountControl" => "Fixed",
            "amount" => $amount,
            "externalReference" => $externalReference
        ];
        $tokenObj = self::getToken();
        logs()->info($tokenObj);
        logs()->info(config('savehaven.safe_haven_base_url').'virtual-accounts');
        logs()->info(json_encode($data));
        $response = $response = Http::withHeaders([
            'accept' => "application/json",
            'content-type' => "application/json",
            "ClientID" => $tokenObj["ibs_client_id"]
        ])->withToken($tokenObj["access_token"])->post(config('savehaven.safe_haven_base_url').'virtual-accounts', $data);
        return  $response->json();
    }


    public static function initiateVerification($type = "BVN", $number) {
        $data = [
            "type" => $type,
            "async" => false,
            "number" => $number,
            "debitAccountNumber" => config('savehaven.safe_haven_account_number'),
        ];
        $tokenObj = self::getToken();
        logs()->info($tokenObj);
        logs()->info(config('savehaven.safe_haven_base_url').'identity/v2');
        logs()->info(json_encode($data));
        $response = $response = Http::withHeaders([
            'accept' => "application/json",
            'content-type' => "application/json",
            "ClientID" => $tokenObj["ibs_client_id"]
        ])->withToken($tokenObj["access_token"])->post(config('savehaven.safe_haven_base_url').'identity/v2', $data);
        return  $response->json();
    }

    public static function transferStatus($paymentReference) {
        $data = [
            "paymentReference" => $paymentReference,
        ];
        $tokenObj = self::getToken();
        logs()->info(config('savehaven.safe_haven_base_url').'transfers/status');
        logs()->info(json_encode($data));
        $response = $response = Http::withHeaders([
            'accept' => "application/json",
            'content-type' => "application/json",
            "ClientID" => $tokenObj["ibs_client_id"]
        ])->withToken($tokenObj["access_token"])->post(config('savehaven.safe_haven_base_url').'transfers/status', $data);
        return  $response->json();
    }

    public static function validateVerification($type = "BVN", $otp, $identityId) {
        $data = [
            "type" => $type,
            "identityId" => $identityId,
            "otp" => $otp,
        ];
        $tokenObj = self::getToken();
        logs()->info(config('savehaven.safe_haven_base_url').'identity/v2/validate');
        logs()->info(json_encode($data));
        $response = $response = Http::withHeaders([
            'accept' => "application/json",
            'content-type' => "application/json",
            "ClientID" => $tokenObj["ibs_client_id"]
        ])->withToken($tokenObj["access_token"])->post(config('savehaven.safe_haven_base_url').'identity/v2/validate', $data);
        return  $response->json();
    }


    public static function nameEnquiry($bankCode, $accountNumber) {
        $data = [
            "bankCode" => $bankCode,
            "accountNumber" => $accountNumber,
        ];
        $tokenObj = self::getToken();
        logs()->info(config('savehaven.safe_haven_base_url').'transfers/name-enquiry');
        logs()->info(json_encode($data));
        $response = $response = Http::withHeaders([
            'accept' => "application/json",
            'content-type' => "application/json",
            "ClientID" => $tokenObj["ibs_client_id"]
        ])->withToken($tokenObj["access_token"])->post(config('savehaven.safe_haven_base_url').'transfers/name-enquiry', $data);
        return  $response->json();
    }


    public static function getBalance($accountId) {
        $tokenObj = self::getToken();
        logs()->info(config('savehaven.safe_haven_base_url').'accounts/'.$accountId);
        logs()->info(json_encode($accountId));
        $response = $response = Http::withHeaders([
            'accept' => "application/json",
            'content-type' => "application/json",
            "ClientID" => $tokenObj["ibs_client_id"]
        ])->withToken($tokenObj["access_token"])->get(config('savehaven.safe_haven_base_url').'accounts/'.$accountId);
        return  $response->json();
    }



    public static function verifyTransaction($referenceCode) {
        $tokenObj = self::getToken();
        logs()->info(config('savehaven.safe_haven_base_url').'checkout/'.$referenceCode.'/verify');
        logs()->info(json_encode($referenceCode));
        $response = $response = Http::withHeaders([
            'accept' => "application/json",
            'content-type' => "application/json",
            "ClientID" => $tokenObj["ibs_client_id"]
        ])->withToken($tokenObj["access_token"])->get(config('savehaven.safe_haven_base_url').'checkout/'.$referenceCode.'/verify');
        return  $response->json();
    }



    public static function getStatement($accountId, $urldata) {
        $tokenObj = self::getToken();
        $url = config('savehaven.safe_haven_base_url').'accounts/'.$accountId.'/statement?'.$urldata;
        logs()->info($url);
        $response = $response = Http::withHeaders([
            'accept' => "application/json",
            'content-type' => "application/json",
            "ClientID" => $tokenObj["ibs_client_id"]
        ])->withToken($tokenObj["access_token"])->get($url);
        return  $response->json();
    }



    public static function getBankList() {
        $tokenObj = self::getToken();
        $url = config('savehaven.safe_haven_base_url').'transfers/banks';
        logs()->info($url);
        $response = $response = Http::withHeaders([
            'accept' => "application/json",
            'content-type' => "application/json",
            "ClientID" => $tokenObj["ibs_client_id"]
        ])->withToken($tokenObj["access_token"])->get($url);
        return  $response->json();
    }


    public static function individualSubAccoount($phoneNumber, $emailAddress, $identityType, $externalReference) {
        $data = [
            // "type" => $type,
            // "async" => false,
            // "number" => $number,
            // "debitAccountNumber" => config('savehaven.safe_haven_account_number')

            "phoneNumber" => $phoneNumber,
            "emailAddress" => $emailAddress,
            "identityType" => "vID",
            "externalReference" => $externalReference,
            "identityId" => $identityType,
            "autoSweep" => false,
            "autoSweepDetails" => [
                "schedule" => "Instant"
            ]
        ];
        $tokenObj = self::getToken();
        logs()->info($tokenObj);
        logs()->info(config('savehaven.safe_haven_base_url').'accounts/v2/subaccount');
        logs()->info(json_encode($data));
        $response = $response = Http::withHeaders([
            'accept' => "application/json",
            'content-type' => "application/json",
            "ClientID" => $tokenObj["ibs_client_id"]
        ])->withToken($tokenObj["access_token"])->post(config('savehaven.safe_haven_base_url').'accounts/v2/subaccount', $data);
        return  $response->json();
    }

}
