<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('members', function (Blueprint $table) {
            $table->id();
            $table->string("member_id")->nullable();
            $table->string("member_name")->nullable();
            $table->string("telegram_id")->nullable();
            $table->string("token_balance")->nullable();
            $table->timestamp('next_subscription_date')->nullable();
            $table->string("fcm_token")->nullable();
            $table->string("member_email")->nullable();
            $table->string("password")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('members');
    }
};
