<?php

use App\Models\Booking;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id();
            $table->string('booking_id')->nullable();
            $table->string('amount_paid')->nullable();
            $table->string('status')->nullable()->default(Booking::INITALIZED);
            $table->foreignId('member_id')->constrained('members')->onDelete('cascade');
            $table->timestamp('booking_start_time')->nullable();
            $table->timestamp('booking_end_time')->nullable();
            $table->string('amount_booked')->nullable();
            $table->longText("member_data")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
