<?php

use App\Models\Booking;
use App\Models\BookingPayment;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_payments', function (Blueprint $table) {
            $table->id();
            $table->string('booking_id')->nullable();
            $table->string('payment_id');
            $table->string('payment_status')->nullable()->default(BookingPayment::PENDING);
            $table->string('payment_method')->nullable();
            $table->string('payment_amount')->nullable();
            $table->string('member_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_payments');
    }
};
