<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->string("member_id");
            $table->string('reference')->unique();
            $table->decimal('amount', 10, 2);
            $table->string('duration'); // daily, weekly, monthly
            $table->timestamp('start_date');
            $table->timestamp('end_date');
            $table->boolean('active')->default(false); // active after payment
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
