<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MemberController;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\BookingConversationController;
use App\Http\Controllers\TelegramController;
use App\Http\Controllers\SubscriptionController;


Route::post('/telegram/webhook', [TelegramController::class, 'webhook']);


Route::prefix('v1')->group(function () {
    Route::get('verify/safe-haven/{referenceCode}', [MemberController::class, 'verifyTransaction']);
    Route::prefix('member')->group(function () {
        Route::get('verify-token/{token}', [MemberController::class, 'verifyToken']);
        Route::post('create', [MemberController::class, 'store']);
        Route::post('login', [MemberController::class, 'login']);
        Route::post('forgot-password', [MemberController::class, 'forgotPassword']);
        Route::post('change-password', [MemberController::class, 'changePassword'])->middleware(['auth:member']);
        Route::post('/subscribe', action: [SubscriptionController::class, 'create']);
        Route::post('/subscribe-coupon', action: [SubscriptionController::class, 'subscribeWithCoupon'])->middleware(['auth:member']);
        Route::get('/subscribe/{reference}', action: [SubscriptionController::class, 'verifyTransaction']);
        Route::prefix('booking')->group(function () {
            Route::post('create', [BookingController::class, 'store'])->middleware(['auth:member']);
            Route::get('list', [BookingController::class, 'index'])->middleware(['auth:member']);
            Route::post('chat', [BookingConversationController::class, 'store'])->middleware(['auth:member']);
            Route::get('generate-doctor-report', [BookingController::class, 'download']);
            Route::get('/{bookingid}', [BookingController::class, 'show'])->middleware(['auth:member']);
        });
    });



    Route::prefix('chat')->group(function () {
        Route::post('create', [ChatController::class, 'create'])->middleware(['auth:member']);
        Route::post('send', [ChatController::class, 'store'])->middleware(['auth:member']);
    });
});


